#include <stdio.h>
#include <string.h>

#define PROG "control"
#define CONNECTIONS 1
#define MAXSERVER 1024
#define GAMEUSER "root"

#include "shared.h"

#include "socket.inc.c"

int main(int argc, char *argv[])
{
	char line[256];
	int count, i;
	int port[MAXSERVER];
	char name[MAXSERVER][256];
	FILE *list, *data;
	int idle[MAXSERVER], ram[MAXSERVER], usage[MAXSERVER], q;
	int servernum, bestnum;
	int bestq;
	int ramneed, mhzneed;
	int servers;
	char command[4096];
	if(argc<6)
	{
		fprintf(stderr, "args 1, 2, 3, 4&5 (serverlist, command, count, mhz needed&ram needed) must be given\n");
		return 0;
	}
	sscanf(argv[3], "%d", &count);
	sscanf(argv[4], "%d", &mhzneed);
	sscanf(argv[5], "%d", &ramneed);
	if(!(list=fopen(argv[1], "r")))
	{
		fprintf(stderr, "canna open %s\n", argv[1]);
		return 1;
	}
	servernum=0;
	while(fgets(line, 255, list))
	{
		sscanf(line, "%d:%s", &port[servernum], name[servernum]);
		if(strcmp(argv[2], "recover"))
		{
			csockinit(0, name[servernum], port[servernum]);
			data=cgetstream(0);
			fscanf(data, "idle (mhz): %d; ram (mb): %d; usage (n): %d\n", &idle[servernum], &ram[servernum], &usage[servernum]);
			cclosestream(0);
		}
		else
		{
			idle[servernum]=1000000;
			ram[servernum]=1000000;
		}
		servernum++;
	}
	servers=servernum;
	fclose(list);
	servernum=0;
	for(i=0;i<count;i++)
	{
		bestq=-999999;
		bestnum=-1;
		if(strcmp(argv[2], "recover"))
		{
			for(servernum=0;servernum<servers;servernum++)
			{
				q=idle[servernum]+ram[servernum]*10-usage[servernum]*5000;
				if((q>bestq)&&(ram[servernum]>=ramneed))
				{
					bestnum=servernum;
					bestq=q;
				}
			}
			if(bestnum==-1)
			{
				fprintf(stderr, "no ram left in cluster - aborting\n");
				return 2;
			}
			idle[bestnum]-=mhzneed;
			ram[bestnum]-=ramneed;
			usage[bestnum]++;
			sprintf(command,
					"xterm -T \"%s : %s\" -e ssh -t -v -v -v "GAMEUSER"@%s \"screen /bin/sh -c \\\"echo "INCCODE" | netcat -q 1 127.0.0.1 %d; %s; echo "DECCODE" | netcat -q 1 127.0.0.1 %d; sleep 5\\\"; sleep 5\" &",
					name[bestnum], argv[2], name[bestnum], CMDPORT, argv[2], CMDPORT);
			fprintf(stderr, "%s\n", command);
			system(command);
			sleep(1);
		}	
		else
			for(servernum=0;servernum<servers;servernum++)
			{
				sprintf(command, "xterm -e ssh -t -v -v -v "GAMEUSER"@%s \"screen -s /bin/false -RR\" &", name[servernum]);
				system(command);
//				sleep(1);
			}
	}
	return 0;
}
