#include <stdio.h>
#include <sched.h>
#include <stdlib.h>
#include <unistd.h>

#define PROG "cpudataserv"
#define CONNECTIONS 2

#include "socket.inc.c"
#include "err.inc.c"

#include "shared.h"

int usertime,nicetime,systemtime,idletime;
int oldusertime,oldnicetime,oldsystemtime,oldidletime;
long int memtotal,memused,memfree,memshared,membuffers,memcached;
long int swaptotal,swapused,swapfree;
int absmhz;
int cpus;
int usage=0;

int usagedaemon(void *no_use)
{
	char code[256];
	FILE *stream;
	ssockinit(CMDPORT, 1);
	ssockstart(1);
	while((stream=sgetstream(1))) {
		fgets(code, 255, stream);
		code[255] = '\0';
		strtok(code, "\n\r");
		if(!strcmp(code, INCCODE)) usage++;
		if(!strcmp(code, DECCODE)) usage--;
		sclosestream(1);
	}
	no_use--;
	return 0;
}

int datadaemon(void *no_use)
{
	FILE *statfile;
	FILE *cpuinfo;
	char cpustring[1024];
	int testmhz;
	printerr("autodetecting Mhz...");
	if(!(cpuinfo=fopen("/proc/cpuinfo","r")))
	{
		printerr("failed - assuming 1400 Mhz");
		absmhz=1400;
	}
	else
	{
		cpus=0;
		absmhz=0;
		while(fgets(cpustring,1024,cpuinfo))
		{
			testmhz=-1;
			sscanf(cpustring,"cpu MHz\t\t: %d",&testmhz);
			if(testmhz>=0)
			{
				absmhz+=testmhz;
				cpus++;
			}
		}
		fclose(cpuinfo);
		if(absmhz==0||cpus==0)
		{
			printerr("failed - assuming 1400 Mhz");
			absmhz=1400;
		}
	}
	printf("Set to %d Mhz\n", absmhz);
	fflush(stdout);
	while(1)
	{
		if((statfile=fopen("/proc/stat","r")))
		{
			fgets(cpustring,1020,statfile);
			oldusertime=usertime;
			oldnicetime=nicetime;
			oldsystemtime=systemtime;
			oldidletime=idletime;
			sscanf(cpustring,"cpu  %d %d %d %d",&usertime,&nicetime,&systemtime,&idletime);
			fclose(statfile);
		}
		else printerr("/proc/stat: file not found");
		if((statfile=fopen("/proc/meminfo","r")))
		{
			strcpy(cpustring, "");
			while(strncmp(cpustring, "MemFree:", 8))
				fgets(cpustring,1020,statfile);
			sscanf(cpustring,"MemFree: %ld",&memfree);
			while(strncmp(cpustring, "Cached:", 7))
				fgets(cpustring,1020,statfile);
			sscanf(cpustring,"Cached: %ld",&memcached);
			fclose(statfile);
		}
		else printerr("/proc/meminfo: file not found");
		sleep(10);
	}
	return 0;
	no_use++;
}

int main(int argc,char *argv[])
{
	int port;
	FILE *stream;
	void *stack;
	if(argc<2)
	{
		fprintf(stderr,"argument 1 (port) must be given\n");
		return 0;
	}
	if(!(stack = malloc(8192))) {
		fprintf(stderr, "malloc for stack space returned NULL\n");
		return 0;
	}
	clone(datadaemon, stack+4095, CLONE_VM | CLONE_THREAD | CLONE_SIGHAND, NULL);
	clone(usagedaemon, stack+8191, CLONE_VM | CLONE_THREAD | CLONE_SIGHAND, NULL);
	sscanf(argv[1],"%d",&port);
	ssockinit(port, 0);
	ssockstart(0);
	while((stream=sgetstream(0)))
	{
		fprintf(stream,"idle (mhz): %d; ram (mb): %ld; usage (n): %d\n",
				(idletime-oldidletime)*absmhz/1000/cpus,
				(long int)((memfree + memcached/1.2)/1024),
				usage);
		sclosestream(0);
	}
	return 0;
}
