#!/bin/bash

TITLE="LANArena-Cluster-Tool"
DIALOG="Xdialog --stdout --no-tags --title $TITLE"
DATABASE="database"
SERVERLIST="lanarena.list"
CONTROL="./control"

while :; do

	COMMAND=$(
	$DIALOG \
	--cancel-label "Exit" \
	--help "\
	This program will start server distributed about the LANArena Server Cluster.
	It is your task now to choose which server should be started.
	If you think you are unable to hande this program go complain at Drahflow.
	If unsure what server you need, ask Ohli.
	" \
	--radiolist "Please choose the server to start" 0 0 10 \
	"cd /games/bin; ./startserverbf1942 --gameid=279" "Battlefield 1942" "" \
	"cd /games/bin; ./startserverbfv --gameid=280" "Battlefield Vietnam" "" \
	"cd /games/bin; ./startservercod --gameid=307" "Call of Duty 3on3" "" \
	"cd /games/bin; ./startservercod --gameid=285" "Call of Duty 5on5" "" \
	"cd /games/bin; ./startservercs2o2 --gameid=286" "Counterstrike 2o2" "" \
	"cd /games/bin; ./startservercs5o5 --gameid=287" "Counterstrike 5o5" "" \
	"cd /games/bin; ./startserverd3 --gameid=288" "Doom 1on1" "" \
	"cd /games/bin; ./startserverfc --gameid=289" "FarCry 5on5" "" \
	"cd /games/bin; ./startserverq31o1 --gameid=292" "Q3 1o1" "" \
	"cd /games/bin; ./startserverq35o5 --gameid=293" "Q3 5o5 CTF" "" \
	"cd /games/bin; ./startserverto --gameid=294" "Tactical Operations 5on5" "" \
	"cd /games/bin; ./startserverut2k41o1 --gameid=295" "Unreal Turnament 1o1" "" \
	"cd /games/bin; ./startserverut2k42o2instagib --gameid=305" "Unreal Turnament 2o2 Instagib" "" \
	"cd /games/bin; ./startserverut2k44o4tdm --gameid=297" "Unreal Turnament 4o4 TDM" "" \
	"false" "/bin/false in person" ""  \
	"less /proc/cpuinfo" "shows /proc/cpuinfo" "" \
	"recover" "recover servers after your XServer has crashed" "" \
	)

	ERROR=$?

	if [ $ERROR == 1 ]; then
		exit 0
	fi

	NUMBER=$(
	$DIALOG \
	--help "\
	Ok - you choosed your server - what now?
	Tell the program what number of servers you need.
	You need one server for every match in this round.
	If you are unsure how many matches the round has, ask Ohli.
	" \
	--spinbox "Please choose the number of the servers to be started" 0 0 \
	1 128 1 "Number of servers"
	)

	ERROR=$?

	if [ $ERROR == 1 ]; then
		continue
	fi

	if ! grep "$COMMAND" $DATABASE >/dev/null; then
		RAMCPU=$(
		$DIALOG \
		--help "\
		Oops - you should never see this dialogbox.
		You now need to perform two steps:
		First, go to Drahflow and complain that his database needs to be extended.
		Second, wait for him to tell you what to do.
		Theroretically you should never see this dialogbox.
		It only appears if you tried to start a server of which the database
		does not know how many resources it needs.
		" \
		--2spinsbox "Please choose the needed resources of the new servers" 0 0 \
		1 512 1 "MB RAM" \
		1 512 1 "MHz CPU time"
		)

		ERROR=$?

		if [ $ERROR == 1 ]; then
			continue
		fi
	else
		RAMCPU=$(
		grep "$COMMAND" $DATABASE | sed -e 's/[^:]*://g'
		)
	fi

	RAM=$( echo $RAMCPU | sed -e 's/\/.*//g' )
	CPU=$( echo $RAMCPU | sed -e 's/[^/]*\///g' )

	$DIALOG \
	--help "\
	Ok - you finished all the starting steps, the program is now going
	to start the servers.
	Please make sure you started not too many servers! Else Ohli or
	Drahflow are going tell the CS-Players that it is _your_ fault that their
	Servers have lag...
	If you are sure what the dialogbox says is ok, then click on yes
	and start the servers. If unsure click no.
	" \
	--yesno "\
	New servers will be started with the following preferences:
	
	$COMMAND
	$NUMBER times
	using $RAM MB and
	$CPU MHz each

	Is that ok?
	" 0 0

	ERROR=$?

	if [ $ERROR == 1 ]; then
		continue
	fi

	$CONTROL "$SERVERLIST" "$COMMAND" "$NUMBER" "$CPU" "$RAM"

done
