#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void emergencyexit(char *s)
{
	fprintf(stderr,"%s: %s\n",PROG,s);
	exit(-1);
}

struct socket
{
  int basefd;
  struct sockaddr_in addr;
  int size;
  int fd;
  FILE *stream;
};

struct socket sock[CONNECTIONS];

void ssockinit(int port, int con)
{
  sock[con].addr.sin_family=AF_INET;
  sock[con].addr.sin_port=htons(port);
  sock[con].size=sizeof(sock[con].addr);
  memset(&sock[con].addr.sin_addr,0,sizeof(sock[con].addr.sin_addr));
  return;
}

void csockinit(int socknum,const char *hostname,int port)
{
  struct hostent *host;
  if((host=gethostbyname(hostname))==NULL)
    emergencyexit("can't resolve host");
  sock[socknum].addr.sin_family=AF_INET;
  sock[socknum].addr.sin_port=htons(port);
  memcpy(&sock[socknum].addr.sin_addr,host->h_addr_list[0],sizeof(sock[socknum].addr.sin_addr));
  return;
}

void ssockstart(int con)
{
  if((sock[con].basefd=socket(PF_INET,SOCK_STREAM,0)) < 0)
    emergencyexit("can't create socket");
  if(bind(sock[con].basefd,(struct sockaddr*)&sock[con].addr,sock[con].size)!=0)
    {
      close(sock[con].fd);
      emergencyexit("can't bind socket");
    }
  if(listen(sock[con].basefd,5)!=0)
    {
      close(sock[con].basefd);
      emergencyexit("can't listen");
    }
  return;
}

FILE *sgetstream(int con)
{
  if((sock[con].fd=accept(sock[con].basefd,(struct sockaddr*)&sock[con].addr,(size_t *)&sock[0].size))<0)
    return(NULL);
  sock[con].stream=fdopen(sock[con].fd,"a+");
  if(sock[con].stream!=NULL)
	  return(sock[con].stream);
 else return NULL;
}

FILE *cgetstream(int socknum)
{
  if((sock[socknum].fd=socket(PF_INET,SOCK_STREAM,0))<0)
    emergencyexit("can't create socket");
  if(connect(sock[socknum].fd,(struct sockaddr*)&sock[socknum].addr,sizeof(sock[socknum].addr))!=0) {
		fprintf(stderr, "%08X\n", sock[socknum].addr.sin_addr.s_addr);
    emergencyexit("can't connect");
	}
  if((sock[socknum].stream=fdopen(sock[socknum].fd,"a+"))==NULL)
    emergencyexit("can't open filediscriptor");
  return(sock[socknum].stream);
}

void sclosestream(int con)
{
  sock[con].fd=fileno(sock[con].stream);
  fclose(sock[con].stream);
	close(sock[con].fd);
  return;
}

void cclosestream(int socknum)
{
  sock[socknum].fd=fileno(sock[socknum].stream);
  fclose(sock[socknum].stream);
  close(sock[socknum].fd);
  return;
}

void ssockstop(int con)
{
  close(sock[con].basefd);
  return;
}
